/***********************************
 *								   *
 *	Scatter Search C code		   *	
 *	Version: 2.0				   *
 *	Authors: M. Laguna & R. Marti  *
 *	Copyright  2002			   *	
 *								   *	
 ***********************************/

#include "SS3c.h"

void SSCreate_P(SS *pb)
/* Creates a set P of PSize different solutions */
{
	int j,currentPSize,equal,fails;
	int *sol,obj_val;

	sol	= SSInt_array(pb->nvar);

	currentPSize=1;fails=0;
	while(currentPSize<=pb->p->PSize && fails<500)
	{
		SSGenerate_Sol(pb,sol);
		obj_val = sol_value(pb,sol);

		SSImprove_solution(pb,sol,&obj_val);

		/* Check if sol is a new one */
		j=1;equal=0;
		while(j<currentPSize && !equal)
			equal=SSEqualSol(sol,pb->p->sol[j++],pb->nvar);

		/* Add solution to set P */
		if(!equal)
		{
			for(j=1;j<=pb->nvar;j++)
				pb->p->sol[currentPSize][j] = sol[j];
			pb->p->ObjVal[currentPSize++] = obj_val;
		}
		else fails++;
	}

	if(currentPSize<pb->p->PSize)
		SSAbort("Reduce the PSize value");

	free(sol+1);
}

void SSGenerate_Sol(SS *pb,int sol[])
{
	double alpha=0.5; /* Percentage for RCL */
	int i,j,a,max_weight,n_candi,threshold;
	int *assigned,*candidate,*weight;	
	
	candidate = SSInt_array(pb->nvar);
	assigned  = SSInt_array(pb->nvar);
	weight    = SSInt_array(pb->nvar);

	/* Initialize weights */
	for(i=1;i<=pb->nvar;i++)
		weight[i]=pb->row_sum[i];

	for(j=1;j<=pb->nvar;j++)
	{   
		/* Maximum weight for non-assigned sectors */
		n_candi=0;
		max_weight=-MAXPOSITIVE;
		for(i=1;i<=pb->nvar;i++)  
			if(!assigned[i] && weight[i]>max_weight)
				max_weight=weight[i];	
	    
		/* Restricted Candidate List */
	    threshold= (int)(alpha*(double)max_weight);
	    for(i=1;i<=pb->nvar;i++)
			if(weight[i]>=threshold && !assigned[i])
				candidate[++n_candi]=i;	
	    
		/* Select one element */
	    a=SSGetrandom(1,n_candi);
	    
	    /* Assign the element */          
	    assigned[candidate[a]]=1;
	    sol[j]=candidate[a];  

		/* Adapt weights */
		for(i=1;i<=pb->nvar;i++) 
        	weight[i] -= pb->data[i][candidate[a]]; 
	}      
	free(candidate+1);free(weight+1);free(assigned+1);
}

void SSPrint_P(SS *pb)
{
	FILE *pf;
	int i,j;

	pf=fopen("setP3.txt","w");
	if(!pf) SSAbort("File opening failure");

	for(i=1;i<=pb->p->PSize;i++)
	{
		fprintf(pf,"\n%2d ",i);
		fprintf(pf,"  %d",pb->p->ObjVal[i]);
		for(j=1;j<=pb->nvar;j++)
			fprintf(pf," %d",pb->p->sol[i][j]);
	}
	fclose(pf);
}





